********************************************************************************
******************************* OPCS code lists ********************************
********************************* Chapter 3.5 **********************************

*     Open log
log using "My file path:\...\CPRD_CodeBrowser_202211_Aurum\CPRD_CodeBrowser_202211_Aurum\Logs\nameoflog"


***************** Step 1: Import Codes and Titles OPCS .txt file ********************
*     Note: Similar to the icd-10 Chapter, this file is a compressed zip file from NHS TRUD.

import delimited "My file path:\...\codes\icd-10\nhs_opcs4df_10.0.0_20221101000001\OPCS410 Data files txt\OPCS410 CodesAndTitles Nov 2022 V1.0.txt", bindquote(nobind) stringcols(_all)




***************** Step 2: Generate lowercase variables *************************
*     Similar to code searching using the Medical/Product .txt file from CPRD Aurum.

gen v2_lower = ustrlower(v2)




***************** Step 3: Searching for inclusion terms ************************
*     We want to generate a new variable 'poss_fracture' that is 1 if the description matches the term 'fracture', and missing otherwise.

gen poss_fracture=.

replace poss_fracture = 1 if strmatch(v2_lower, "*fracture*")
replace poss_fracture = 1 if strmatch(v2_lower, "*vertebr*")

keep if poss_fracture==1



*     Save the file as a .dta
save "My file path:\...\opcs_codelist.dta"


*     Close log
log close

